import { StarXpandCommand } from "star-io10-web";

export class LabelSample10_For203dpi_CoffeeOrder_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 80.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    20.0,
                    3.0,
                    10.0,
                    10.0,
                  ).setThickness(0.4),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    50.0,
                    3.0,
                    10.0,
                    10.0,
                  ).setThickness(0.4),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    20.0,
                    18.0,
                    10.0,
                    10.0,
                  ).setThickness(0.4),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    50.0,
                    18.0,
                    10.0,
                    10.0,
                  ).setThickness(0.4),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    20.0,
                    31.0,
                    40.0,
                    10.0,
                  ).setThickness(0.4),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    20.0,
                    45.0,
                    40.0,
                    10.0,
                  ).setThickness(0.4),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    20.0,
                    59.0,
                    10.0,
                    6.0,
                  ).setThickness(0.4),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    44.0,
                    59.0,
                    16.0,
                    6.0,
                  ).setThickness(0.4),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(12.0, 80.0)
                    .setX(0.0)
                    .setY(0.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleBold(true)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .stylePrintDirection(
                      StarXpandCommand.Printer.PageModePrintDirection
                        .BottomToTop,
                    )
                    .styleVerticalPositionTo(6.0)
                    .actionPrintText(
                      "${store_name}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        24,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Right,
                        ),
                      ),
                    ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(60.0, 80.0)
                    .setX(12.0)
                    .setY(0.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleHorizontalPositionTo(8.0)
                    .styleVerticalPositionTo(0.0)
                    .actionPrintText(
                      "Decaf",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        6,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .styleHorizontalPositionTo(38.0)
                    .actionPrintText(
                      "Shots\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        6,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .add(
                      new StarXpandCommand.PageModeBuilder()
                        .styleMagnification(
                          new StarXpandCommand.MagnificationParameter(2, 2),
                        )
                        .styleHorizontalPositionTo(8.0)
                        .styleVerticalPositionBy(4.0)
                        .actionPrintText(
                          "${decaf}",
                          new StarXpandCommand.Printer.TextParameter().setWidth(
                            3,
                            new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                              StarXpandCommand.Printer.TextAlignment.Center,
                            ),
                          ),
                        )
                        .styleHorizontalPositionTo(38.0)
                        .actionPrintText(
                          "${shots}\n",
                          new StarXpandCommand.Printer.TextParameter().setWidth(
                            3,
                            new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                              StarXpandCommand.Printer.TextAlignment.Center,
                            ),
                          ),
                        ),
                    )
                    .styleHorizontalPositionTo(8.0)
                    .styleVerticalPositionTo(15.0)
                    .actionPrintText(
                      "Size",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        6,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .styleHorizontalPositionTo(38.0)
                    .actionPrintText(
                      "Milk\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        6,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .add(
                      new StarXpandCommand.PageModeBuilder()
                        .styleMagnification(
                          new StarXpandCommand.MagnificationParameter(2, 2),
                        )
                        .styleHorizontalPositionTo(8.0)
                        .styleVerticalPositionBy(4.0)
                        .actionPrintText(
                          "${size}",
                          new StarXpandCommand.Printer.TextParameter().setWidth(
                            3,
                            new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                              StarXpandCommand.Printer.TextAlignment.Center,
                            ),
                          ),
                        )
                        .styleHorizontalPositionTo(38.0)
                        .actionPrintText(
                          "${milk}\n",
                          new StarXpandCommand.Printer.TextParameter().setWidth(
                            3,
                            new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                              StarXpandCommand.Printer.TextAlignment.Center,
                            ),
                          ),
                        ),
                    )
                    .styleHorizontalPositionTo(8.0)
                    .styleVerticalPositionTo(28.0)
                    .actionPrintText(
                      "Syrup\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        27,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .add(
                      new StarXpandCommand.PageModeBuilder()
                        .styleMagnification(
                          new StarXpandCommand.MagnificationParameter(2, 2),
                        )
                        .styleHorizontalPositionTo(8.0)
                        .styleVerticalPositionBy(4.0)
                        .actionPrintText(
                          "${syrup}\n",
                          new StarXpandCommand.Printer.TextParameter().setWidth(
                            13,
                            new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                              StarXpandCommand.Printer.TextAlignment.Center,
                            ),
                          ),
                        ),
                    )
                    .styleHorizontalPositionTo(8.0)
                    .styleVerticalPositionTo(42.0)
                    .actionPrintText(
                      "Custom\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        27,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .add(
                      new StarXpandCommand.PageModeBuilder()
                        .styleMagnification(
                          new StarXpandCommand.MagnificationParameter(2, 2),
                        )
                        .styleHorizontalPositionTo(8.0)
                        .styleVerticalPositionBy(4.0)
                        .actionPrintText(
                          "${custom}\n",
                          new StarXpandCommand.Printer.TextParameter().setWidth(
                            13,
                            new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                              StarXpandCommand.Printer.TextAlignment.Center,
                            ),
                          ),
                        ),
                    )
                    .styleHorizontalPositionTo(8.0)
                    .styleVerticalPositionTo(56.0)
                    .actionPrintText(
                      "Drink",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        6,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .styleHorizontalPositionTo(32.0)
                    .actionPrintText(
                      "Iced\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        10,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .add(
                      new StarXpandCommand.PageModeBuilder()
                        .styleHorizontalPositionTo(8.0)
                        .styleVerticalPositionBy(1.0)
                        .actionPrintText(
                          "${drink}",
                          new StarXpandCommand.Printer.TextParameter().setWidth(
                            6,
                            new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                              StarXpandCommand.Printer.TextAlignment.Center,
                            ),
                          ),
                        )
                        .styleHorizontalPositionTo(32.0)
                        .actionPrintText(
                          "${iced}\n",
                          new StarXpandCommand.Printer.TextParameter().setWidth(
                            10,
                            new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                              StarXpandCommand.Printer.TextAlignment.Center,
                            ),
                          ),
                        ),
                    )
                    .add(
                      new StarXpandCommand.PageModeBuilder()
                        .styleMagnification(
                          new StarXpandCommand.MagnificationParameter(2, 2),
                        )
                        .styleVerticalPositionBy(3.0)
                        .actionPrintText("Name:")
                        .styleHorizontalPositionBy(1.0)
                        .actionPrintText(
                          "${customer_name}\n",
                          new StarXpandCommand.Printer.TextParameter().setWidth(
                            14,
                          ),
                        ),
                    )
                    .actionPrintText("FOR HERE")
                    .actionPrintText(
                      "${item_number} of ${total_items}",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        32,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Right,
                        ),
                      ),
                    )
                    .actionPrintText(
                      "${order_number}",
                      new StarXpandCommand.Printer.TextParameter().setWidth(30),
                    )
                    .actionPrintText(
                      "${time}",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        10,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Right,
                        ),
                      ),
                    ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "store_name" : "STAR COFFEE",
    "decaf" : "",
    "shots" : "2",
    "size" : "L",
    "milk" : "N",
    "syrup" : "C",
    "custom" : "WC",
    "drink" : "HC",
    "iced" : "",
    "customer_name" : "John Smith",
    "item_number" : 1,
    "total_items" : 2,
    "order_number" : "SB038r1-0459138",
    "time" : "6:25 PM"
}`,
    );
  }
}
